define(['backbone', 'marionette', 'jquery', 'underscore'], function ( Backbone, Marionette, $, _) {
	'use strict';

//	Portal.module('WoundCareApplet', function (, Portal, Backbone, Marionette, $, _) {

//		WoundCareApplet.SkinCheckModel =
		return Backbone.Model.extend({
			bradenPlus: null,
			bradenPast: null,
			initialize: function(url) {
				
				this.url = url;
			},
			formatDate: function(str) {
        return str.split('.')[0].replace('T', ' ');
      },
			parse: function(response) {
				console.log(response);
				this.bradenPlus = this.staticBraden();
				if (response && response.pastBradenAssessment) {
					var val = response.pastBradenAssessment;
					this.bradenPast = this.staticBraden();
					for (var key in this.bradenPlus.braden) {
						if(this.bradenPlus.braden[key].values[this.bradenPlus.braden[key].values.length - val[key]])
							this.bradenPlus.braden[key].values[this.bradenPlus.braden[key].values.length - val[key]].lastValue = this.formatDate(val.updateDate);
						this.bradenPast.braden[key].lastValue = val[key];
					}
				}
				return response;
			},
			staticBraden: function() {
				return {
					'copyright': 'Copyright, Barbara Braden and Nancy Bergstrom, 1988. Reprinted with permission. All rights reserved.',
					'braden' : {
						'sensoryPerception' : {
							name: 'Sensory Perception',
							desc: 'Ability to respond meaningfully to pressure- related discomfort',
							'values': [
								{
									number: 4,
									name: 'No Impairment',
									desc: 'Responds to verbal commands. Has no sensory deficit which would limit ability to feel or voice pain or discomfort.'
								}, {
									number: 3,
									name: 'Slightly Limited',
									desc: 'Responds to verbal commands, but cannot always communicate discomfort or need to be turned. OR has some sensory impairment which limits ability to feel pain or discomfort in 1 or 2 extremities.'
								}, {
									number: 2,
									name: 'Very Limited',
									desc: 'Responds only to painful stimuli. Cannot communicate discomfort except by moaning or restlessness. OR has a sensory impairment which limits the ability to feel pain or discomfort over 1/2 of body.'
								}, {
									number: 1,
									name: 'Completely Limited',
									desc: 'Unresponsive (does not moan, flinch or grasp) to painful stimuli, due to diminished level of consciousness or sedation. OR limited ability to feel pain over most of body surface.'
								}
							]
						},
						'moisture' : {
							name:'Moisture',
							desc: 'Degree to which skin is exposed to moisture',
							values: [
								{
									number: 4,
									name: 'Rarely Moist',
									desc: 'Skin is usually dry. Linen only requires changing at routine intervals.'
								}, {
									number: 3,
									name: 'Occasionally Moist',
									desc: 'Skin is occasionally moist, requiring an extra linen change approximately once a day.'
								}, {
									number: 2,
									name: 'Very Moist',
									desc: 'Skin is often, but not always, moist. Linen must be changed at least once a shift.'
								}, {
									number: 1,
									name: 'Constantly Moist',
									desc: 'Skin is kept moist almost constantly by perspiration, urine, etc. Dampness is detected every time patient is moved or turned.'
								}
							]
						},
						'activity' : {
							name: 'Activity',
							desc: 'Degree of physical activity',
							values: [
								{
									number: 4,
									name: 'Walks Frequently',
									desc: 'Walks outside the room at least twice a day and inside room at least once every 2 hours during waking hours.'
								}, {
									number: 3,
									name: 'Walks Occasionally',
									desc:	'Walks occasionally during day, but for very short distances, with or without assistance. Spends majority of each shift in bed or chair.'
								}, {
									number: 2,
									name: 'Chairfast',
									desc: 'Ability to walk severely limited or non-existent. Cannot bear own weight and/or must be assisted into chair or wheelchair.'
								}, {
									number: 1,
									name: 'Bedfast',
									desc: 'Confined to bed.'
								}
							]
						},
						'mobility' : {
							name: 'Mobility',
							desc: 'Ability to change and control body position',
							values: [{
								number: 4,
								name: 'No Limitations',
								desc: 'Makes major and frequent changes in position without assistance.'
							}, {
								number: 3,
								name: 'Slightly Limited',
								desc: 'Makes frequent though slight changes in body or extremity position independently.'
							}, {
								number: 2,
								name: 'Very Limited',
								desc: 'Makes occasional slight changes in body or extremity position but unable to make frequent or significant changes independently.'
							}, {
								number: 1,
								name: 'Completely Immobile',
								desc: 'Does not make even slight changes in body or extremity position without assistance.'
							} ]
						},
						'nutrition' : {
							name: 'Nutrition',
							desc: 'Usual food intake pattern',
							values: [{
								number: 4,
								name: 'Excellent',
								desc: 'Eats most of every meal. Never refuses a meal. Usually eats a total of 4 or more servings of meat and dairy products. Occasionally eats between meals. Does not require supplementation.'
							}, {
								number: 3,
								name: 'Adequate',
								desc: 'Eats over half of most meals. Eats a total of 4 servings of protein (meat, dairy products) each day. Occasionally will refuse a meal, but will usually take a supplement if offered. OR is on a tube feeding or TPN regimen which probably meets most of nutritional needs.'
							}, {
								number: 2,
								name: 'Probably Inadequate',
								desc: 'Rarely eats a complete meal and generally eats only about 1/2 of any food offered. Protein intake includes only 3 servings of meat or dairy products per day. Occasionally will take a dietary supplement. OR receives less than optimum amount of liquid diet or tube feeding.'
							}, {
								number: 1,
								name: 'Very Poor',
								desc: 'Never eats a complete meal. Rarely eats more than 1/3 of any food offered. Eats 2 servings or less of protein (meat or dairy products) per day. Takes fluids poorly. Does not take a liquid dietary supplement. OR is NPO and/or maintained on clear liquids or I.V.’s for more than 5 days.'
							}]
						},
						'frictionAndShear': {
							name:'Friction and Shear',
							desc: '',
							values: [{
								number: 3,
								name: 'No Apparent Problem',
								desc: 'Moves in bed and in chair independently and has sufficient muscle strength to lift up completely during move. Maintains good position in bed or chair at all times.'
							}, {
								number: 2,
								name: 'Potential Problem',
								desc: 'Moves feebly or requires minimum assistance. During a move, skin probably slides to some extent against sheets, chair restraints, or other devices. Maintains relatively good position in chair or bed most of the time, but occasionally slides down.'
							}, {
								number: 1,
								name: 'Problem',
								desc: 'Requires moderate to maximum assistance in moving. Complete lifting without sliding against sheets is impossible. Frequently slides down in bed or chair, requiring frequent repositioning with maximum assistance. Spasticity, contractures or agitation lead to almost constant friction.'
							}]
						}
					}
				};
			}
		});
//	});
});